/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.mssClient;

import ibm.nways.cfgtool.CfgToolContext;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.launcher.LaunchContext;
import ibm.nways.mib2.SystemGeneralGroup;
import ibm.nways.mssClient.BoxGraphic;
import ibm.nways.mssClient.CodeLevelMssClient;
import ibm.nways.mssClient.OidConst;
import ibm.nways.mssClient.eui.ConfigurationFolderGroup;
import ibm.nways.mssClient.eui.FaultGroup;
import ibm.nways.ras.RAS;
import ibm.nways.rping.eui.RpingBasePanel;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.telnet.TelnetPanel;
import ibm.nways.web.WebContext;
import java.io.Serializable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class MssClient
extends JdmBrowser {
    CodeLevelMssClient codeLevel = new CodeLevelMssClient();
    private static ResourceBundle resBundle = null;
    private static int deviceStatus = 999;
    private GenModel mssClientModel;
    private NavFieldOverride feOverrides;
    private NavigationBrowser tree;
    private SnmpContextModel contextModel;
    private static final int RASID = 19;
    private static final int RASSUB = 27;
    static final Object[][] feFieldOverrides = new Object[][]{{"ibm.nways.appletalk.model.Port.Panel.AtportType.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportNetStart.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportNetEnd.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportNetAddress.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportStatus.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportZone.access", "read-only"}, {"ibm.nways.appletalk.model.Port.Panel.AtportIfIndex.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpRangeStart.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpRangeEnd.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpNextHop.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpType.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpPort.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpHops.access", "read-only"}, {"ibm.nways.appletalk.model.Routing.Panel.RtmpState.access", "read-only"}, {"ibm.nways.appletalk.model.Zone.Panel.ZipZoneName.access", "read-only"}, {"ibm.nways.appletalk.model.Zone.Panel.ZipZoneNetStart.access", "read-only"}, {"ibm.nways.appletalk.model.Zone.Panel.ZipZoneNetEnd.access", "read-only"}, {"ibm.nways.appletalk.model.Zone.Panel.ZipZoneState.access", "read-only"}, {"ibm.nways.appletalk.model.Nbp.Panel.NbpObject.access", "read-only"}, {"ibm.nways.appletalk.model.Nbp.Panel.NbpType.access", "read-only"}, {"ibm.nways.appletalk.model.Nbp.Panel.NbpZone.access", "read-only"}, {"ibm.nways.appletalk.model.Nbp.Panel.NbpState.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVpcs.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxVccs.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxActiveVpiBits.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceMaxActiveVciBits.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceIlmiVpi.access", "read-only"}, {"ibm.nways.atm.model.AtmInterface.Panel.AtmInterfaceIlmiVci.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrType.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam1.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam2.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam3.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam4.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam5.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficQoSClass.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclAdminStatus.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclReceiveTrafficDescrIndex.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclTransmitTrafficDescrIndex.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAalType.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5CpcsTransmitSduSize.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5CpcsReceiveSduSize.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5EncapsType.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerAdminStatus.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerConnectRetryInterval.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerHoldTimeConfigured.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerKeepAliveConfigured.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerMinASOriginationInterval.access", "read-only"}, {"ibm.nways.bgp.model.Peer.Panel.BgpPeerMinRouteAdvertisementInterval.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dStpPortPriority.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dStpPortEnable.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dStpPortPathCost.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortHopCount.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortLocalSegment.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortBridgeNum.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortTargetSegment.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortLargestFrame.access", "read-only"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dSrPortSTESpanMode.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dStpPriority.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dStpBridgeMaxAge.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dStpBridgeHelloTime.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dStpBridgeForwardDelay.access", "read-only"}, {"ibm.nways.bridge.model.Bridging.Panel.Dot1dTpAgingTime.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaArpClient.Panel.IpoaArpClientAtmAddr.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaArpSrvr.Panel.IpoaArpSrvrLis.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaConfigPvc.Panel.IpoaConfigPvcDefaultMtu.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisDefaultMtu.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisDefaultEncapsType.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisQDepth.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisMaxCalls.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisRetries.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisDefaultPeakCellRate.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisInactivityTimer.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisMinHoldingTime.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisTimeout.access", "read-only"}, {"ibm.nways.ipoa.model.IpoaLisIfMapping.Panel.IpoaLisCacheEntryAge.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxBasicSysExistState.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxBasicSysNetNumber.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxBasicSysNode.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxBasicSysName.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxAdvSysMaxPathSplits.access", "read-only"}, {"ibm.nways.ipx.model.General.Panel.IpxAdvSysMaxHops.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircExistState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircOperState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircIfIndex.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircName.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircType.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircDialName.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircLocalMaxPacketSize.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircCompressState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircCompressSlots.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircStaticStatus.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.IpxCircNetNumber.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircPace.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircUpdate.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircAgeMultiplier.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.RipCircPacketSize.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircState.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircPace.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircUpdate.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircAgeMultiplier.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircPacketSize.access", "read-only"}, {"ibm.nways.ipx.model.Circuit.Panel.SapCircGetNearestServerReply.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteNetNum.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteCircIndex.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteExistState.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteTicks.access", "read-only"}, {"ibm.nways.ipx.model.StaticRoutes.Panel.IpxStaticRouteHopCount.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServSysInstance.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServCircIndex.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServName.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServType.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServExistState.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServNetNum.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServNode.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServSocket.access", "read-only"}, {"ibm.nways.ipx.model.StaticServ.Panel.IpxStaticServHopCount.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigMode.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigLesAtmAddress.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigLanName.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigLanType.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigMaxDataFrameSize.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecControlTimeout.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxUnknownFrameCount.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxUnknownFrameTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecVccTimeoutPeriod.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxRetryCount.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecAgingTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecForwardDelayTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecExpectedArpResponseTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecFlushTimeOut.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecPathSwitchingDelay.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendType.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendAvgRate.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendPeakRate.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConnectionCompleteTimer.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}, {"ibm.nways.mib2.model.IpParam.Panel.IpForwarding.access", "read-only"}, {"ibm.nways.mib2.model.IpParam.Panel.IpDefaultTTL.access", "read-only"}, {"ibm.nways.mib2.model.Interface.Panel.IfPromiscuousMode.access", "read-only"}, {"ibm.nways.mib2.model.Interface.Panel.IfLinkUpDownTrapEnable.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.System.Panel.SysContact.length", "79"}, {"ibm.nways.mib2.model.System.Panel.SysName.length", "79"}, {"ibm.nways.mib2.model.System.Panel.SysLocation.length", "79"}, {"ibm.nways.ospf.model.Area.Panel.OspfAuthType.access", "read-only"}, {"ibm.nways.ospf.model.Area.Panel.OspfImportASExtern.access", "read-only"}, {"ibm.nways.ospf.model.AreaRange.Panel.OspfAreaRangeAreaID.access", "read-only"}, {"ibm.nways.ospf.model.AreaRange.Panel.OspfAreaRangeNet.access", "read-only"}, {"ibm.nways.ospf.model.AreaRange.Panel.OspfAreaRangeMask.access", "read-only"}, {"ibm.nways.ospf.model.AreaRange.Panel.OspfAreaRangeStatus.access", "read-only"}, {"ibm.nways.ospf.model.General.Panel.OspfRouterId.access", "read-only"}, {"ibm.nways.ospf.model.General.Panel.OspfAdminStat.access", "read-only"}, {"ibm.nways.ospf.model.General.Panel.OspfASBdrRtrStatus.access", "read-only"}, {"ibm.nways.ospf.model.General.Panel.OspfTOSSupport.access", "read-only"}, {"ibm.nways.ospf.model.Host.Panel.OspfHostIpAddress.access", "read-only"}, {"ibm.nways.ospf.model.Host.Panel.OspfHostMetric.access", "read-only"}, {"ibm.nways.ospf.model.Host.Panel.OspfHostStatus.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfIpAddress.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfAddressLessIf.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfAreaId.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfType.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfAdminStat.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfRtrPriority.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfTransitDelay.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfRetransInterval.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfHelloInterval.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfRtrDeadInterval.access", "read-only"}, {"ibm.nways.ospf.model.Interfaces.Panel.OspfIfPollInterval.access", "read-only"}, {"ibm.nways.ospf.model.Neighbor.Panel.OspfNbrIpAddr.access", "read-only"}, {"ibm.nways.ospf.model.Neighbor.Panel.OspfNbrAddressLessIndex.access", "read-only"}, {"ibm.nways.ospf.model.Neighbor.Panel.OspfNbrPriority.access", "read-only"}};

    public MssClient() {
        resBundle = ResourceBundle.getBundle("ibm.nways.mssClient.Resources");
    }

    private void getInit() {
        try {
            this.mssClientModel = (GenModel)this.getModel();
            if (RAS.isEnabled(19, 27)) {
                RAS.trace(19, 27, (Object)this, "getInit", "Got Client Model");
            }
            this.getInitialDeviceInfo();
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 27, (Object)this, "getInit", exception);
            return;
        }
    }

    private void getInitialDeviceInfo() {
        try {
            OID oID;
            ModelInfo modelInfo = this.mssClientModel.getInfo("Config");
            Serializable serializable = modelInfo.get("Config.SysObjectID");
            if (serializable instanceof Timeout || serializable instanceof NotSupported) {
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, (Object)this, "getInitialDeviceInfo", "Can't talk to the Device " + serializable.toString());
                }
                deviceStatus = 99;
                new BoxDownMsg(this.getFrame(), resBundle.getString("CLIENT_JDM"));
                return;
            }
            String string = serializable.toString();
            if (RAS.isEnabled(19, 27)) {
                RAS.trace(19, 27, (Object)this, "getInitialDeviceInfo", "sysOid = " + string);
            }
            if (OidConst.FEROUTER_OID.equals(oID = new OID(string))) {
                deviceStatus = 4;
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, (Object)this, "getInitialDeviceInfo", "deviceStatus = FEROUTER");
                }
            } else if (OidConst.FE_OID.equals(oID)) {
                deviceStatus = 5;
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, (Object)this, "getInitialDeviceInfo", "deviceStatus = FE");
                }
            } else {
                deviceStatus = 999;
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, (Object)this, "getInitialDeviceInfo", "deviceStatus = UNKNOWN");
                }
                new WrongSysOidMsg(this.getFrame(), resBundle.getString("CLIENT_JDM"));
            }
            String string2 = modelInfo.get("Config.SysDescr").toString();
            this.codeLevel = new CodeLevelMssClient(string2);
            if (RAS.isEnabled(19, 27)) {
                RAS.trace(19, 27, (Object)this, "getInitialDeviceInfo", "sysDescr = " + string2 + "codeLevel = " + this.codeLevel.toString());
            }
            modelInfo = this.mssClientModel.getInfo("Config");
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 27, (Object)this, "getInitialDeviceInfo", exception);
            return;
        }
    }

    private String chooseOne(String string, String string2, String string3) {
        String string4;
        switch (deviceStatus) {
            case 4: {
                string4 = string;
                break;
            }
            case 5: {
                string4 = string2;
                break;
            }
            default: {
                string4 = string3;
            }
        }
        return string4;
    }

    public String getModelTypeName() {
        return "ibm.nways.mssClient.model.MssClient";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        this.displayMsg(resBundle.getString("START_GRAPHIC"));
        GraphicPanel graphicPanel = null;
        this.mssClientModel = (GenModel)this.getModel();
        if (deviceStatus == 5 || deviceStatus == 4) {
            BoxGraphic boxGraphic = new BoxGraphic(this, deviceStatus);
            boxGraphic.setMssClientModel(this.mssClientModel);
            graphicPanel = boxGraphic.getGraphicPanel();
        }
        this.displayMsg(resBundle.getString("END_GRAPHIC"));
        return graphicPanel;
    }

    public static int getDeviceStatus() {
        return deviceStatus;
    }

    protected NavigationPoint getNavTreeRoot() {
        NavigationFolder navigationFolder;
        this.getInit();
        if (deviceStatus != 5 && deviceStatus != 4) {
            if (RAS.isEnabled(19, 27)) {
                RAS.trace(19, 27, (Object)this, "getInit", "deviceStatus = " + deviceStatus);
            }
            navigationFolder = new NavigationFolder(resBundle.getString("UNKNOWN"));
        } else {
            String string = this.chooseOne("MSS_DOMAIN_CLIENT", "MSS_CLIENT", "UNKNOWN_DEVICE");
            navigationFolder = new NavigationFolder(resBundle.getString(string));
        }
        NavigationContext navigationContext = navigationFolder.getNavContext();
        this.feOverrides = new NavFieldOverride(navigationContext, feFieldOverrides);
        navigationContext.put((Object)"codeLevel", (Object)this.codeLevel);
        return navigationFolder;
    }

    protected void getRestOfNavTree() {
        Vector<Properties> vector = new Vector<Properties>();
        NavigationFolder navigationFolder = (NavigationFolder)this.getNavigationTree();
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = navigationFolder.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        try {
            Object object;
            LaunchContext launchContext;
            ModelInfo modelInfo = this.mssClientModel.getInfo("Config");
            String string = modelInfo.get("Config.Fe827xSwitchIPAddr").toString();
            if (RAS.isEnabled(19, 27)) {
                RAS.trace(19, 27, (Object)this, "getRestOfNavTree", "Switch IP Address = " + string);
            }
            if ((launchContext = new LaunchContext()).containsKey("827xKalpana")) {
                object = launchContext.getName("827xKalpana");
                String string2 = String.valueOf(object) + "[" + string + "]";
                launchContext.setNavTitle("827xKalpana", string2);
                launchContext.setIpAddress("827xKalpana", string);
                Properties properties = launchContext.getProp("827xKalpana");
                vector.addElement(properties);
                if (RAS.isEnabled(19, 27)) {
                    RAS.trace(19, 27, (Object)this, "getRestOfNavTree", "launch Context = " + vector.toString());
                }
                navigationContext.put((Object)"launcherFolderContext", vector);
            }
            GenModel genModel = (GenModel)this.mssClientModel.getComponent("ConfigurationFolder");
            if (RAS.isEnabled(19, 27)) {
                RAS.trace(19, 27, (Object)this, "getRestOfNavTree", "Got ConfigurationFolder  " + genModel);
            }
            if (genModel == null || deviceStatus == 99) {
                try {
                    object = (GenModel)this.mssClientModel.getComponent("System");
                    if (RAS.isEnabled(19, 27)) {
                        RAS.trace(19, 27, (Object)this, "getRestOfNavTree", "Got System  " + object);
                    }
                    SystemGeneralGroup systemGeneralGroup = new SystemGeneralGroup((JdmBrowser)this, (GenModel)object);
                    systemGeneralGroup.setIsInitiallyExpanded(false);
                    this.tree.addEventListener((NavigationBrowserEventListener)systemGeneralGroup);
                    navigationFolder.add((NavigationPoint)systemGeneralGroup);
                }
                catch (Exception exception) {
                    RAS.logException(19, 27, (Object)this, "getRestOfNavTree", exception);
                }
            } else {
                ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
                configurationFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
                navigationFolder.add((NavigationPoint)configurationFolderGroup);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 27, (Object)this, "getRestOfNavTree", exception);
        }
        this.buildFaultFolder(navigationFolder);
        this.buildToolsFolder(navigationFolder);
        this.displayMsg(resBundle.getString("DONE"));
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        try {
            GenModel genModel = (GenModel)this.mssClientModel.getComponent("Traps");
            if (RAS.isEnabled(19, 27)) {
                RAS.trace(19, 27, (Object)this, "buildFaultFaultFolder", "Got Traps  " + genModel);
            }
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, this.mssClientModel);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            navigationFolder.add((NavigationPoint)faultGroup);
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 27, (Object)this, "buildFaultFolder", exception);
            return;
        }
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        ModelInfo modelInfo;
        RemoteModel remoteModel;
        NavigationFolder navigationFolder2 = new NavigationFolder(resBundle.getString("Tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            ResourceBundle resourceBundle;
            Object object;
            NavigationBrowser navigationBrowser;
            remoteModel = (SnmpContextModel)this.mssClientModel.getComponent("_ContextInfo");
            modelInfo = remoteModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string);
            NavigationItem navigationItem = new NavigationItem(TelnetPanel.getTitle(), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            String string2 = System.getProperty("os.name");
            if (this.getIsApplication() && (string2.equals("Windows NT") || string2.equals("AIX"))) {
                navigationBrowser = CfgToolContext.autoDetect((String)"MSSC", (int)this.codeLevel.version, (int)this.codeLevel.release, (int)this.codeLevel.maintenance);
                if (navigationBrowser == null) {
                    navigationBrowser = this.codeLevel.atLevel(2, 1, 0, 0) ? new CfgToolContext("MSSCLIENT_V2R1") : new CfgToolContext("MSSCLIENT_DEFAULT");
                }
                object = ResourceBundle.getBundle("ibm.nways.cfgtool.CfgToolGroupResources");
                resourceBundle = new NavigationItem(((ResourceBundle)object).getString("cfgtoolPanelTitle"), new NavigationDestination("ibm.nways.cfgtool.CfgToolPanel", null), "CfgTool");
                navigationContext = resourceBundle.getNavContext();
                navigationContext.put((Object)"cfgtoolContext", (Object)navigationBrowser);
                navigationFolder2.add((NavigationPoint)resourceBundle);
            }
            navigationBrowser = this.getNavigationBrowser();
            object = new Browser("MIB Browser", (JdmBrowser)this, remoteModel);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)object);
            navigationFolder2.add((NavigationPoint)object.getRootFolder());
            resourceBundle = ResourceBundle.getBundle("ibm.nways.web.Resources");
            WebContext webContext = new WebContext(string);
            if (deviceStatus == 5) {
                webContext.mssClientDefaults();
            } else {
                webContext.mssDomainClientDefaults();
            }
            NavigationItem navigationItem2 = new NavigationItem(resourceBundle.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem2.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem2);
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                NavigationItem navigationItem3 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem3.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem3);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 27, (Object)this, "buildToolsFolder", exception);
        }
        try {
            remoteModel = (GenModel)this.mssClientModel.getComponent("Rping");
            modelInfo = new NavigationItem(RpingBasePanel.getTitle(), new NavigationDestination("ibm.nways.rping.RpingPanel", remoteModel), "Rping");
            navigationFolder2.add((NavigationPoint)modelInfo);
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 27, (Object)this, "buildToolsFolder", exception);
            return;
        }
    }

    public void dispose() {
        if (RAS.isEnabled(19, 27)) {
            RAS.trace(19, 27, (Object)this, "dispose", "In Dispose");
        }
        new CodeLevelMssClient();
        this.mssClientModel = null;
        this.feOverrides = null;
        this.tree = null;
        this.contextModel = null;
        super.dispose();
    }
}

